﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Core.GIODO" %>
<%@ Import Namespace="Soneta.Core.UI.GIODO" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Zgłoszenie naruszenia</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">

        void OnContextLoad(Object sender, EventArgs args) {
            CoreModule cm = CoreModule.GetInstance(dc);
            Firma.EditValue = cm.Config.Firma.Pieczątka.Nazwa;
        }

    </script>

</head>
<body>
    <form method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Core.GIODO.GIODONaruszenie, Soneta.Core"></ea:datacontext>
        <eb:ReportHeader id="ReportHeader" runat="server" title="Naruszenie ochrony danych osobowych"></eb:ReportHeader>

        <table id="Table1" cellspacing="0" cellpadding="1" width="100%" border="0" style="font-family: Tahoma; font-size: 9pt; margin-top: 20px; margin-bottom: 30px;">
            <tr>
                <td style="">
                    <br />
                    W trybie art. 33 Ogólnego Rozporządzenia o Ochronie Danych Osobowych niniejszym zgłaszam naruszenie danych osobowych w
                    <ea:datalabel id="Firma" runat="server" Bold="true"></ea:datalabel>.
                </td>
            </tr>
        </table>
        <table id="Table2" cellspacing="0" cellpadding="1" width="100%" border="1" style="font-family: Tahoma; font-size: 9pt; margin-top: 20px; margin-bottom: 30px; ">
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Data i godzina naruszenia</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="DataNaruszenia" runat="server" Bold="false"></ea:datalabel>
                    <ea:datalabel DataMember="CzasNaruszenia" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Kategoria osób</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="ZbiorDanych.KategoriaOsob" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Przybliżona liczba osób</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="LiczbaOsob" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Dane administratora danych</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="ZbiorDanych.AdministratorDanychOsobowych" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Dane inspektora ochrony danych</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="ZbiorDanych.InspektorDanychOsobowych" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Charakter naruszenia (w tym kategorie i przybliżona liczba wpisów danych osobowych)</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="Opis" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Możliwe konsekwencje naruszenia ochrony danych osobowych</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="Konsekwencje" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td width="40%" style="text-align: left;">
                    <b>Środki zastosowane lub proponowane w celu zaradzenia naruszeniu ochrony danych osobowych</b>
                </td>
                <td width="60%" style="text-align: left;">
                    <ea:datalabel DataMember="SrodkiZaradzenia" runat="server" Bold="false"></ea:datalabel>
                </td>
            </tr>
        </table>
        <eb:ReportFooter id="ReportFooter" runat="server">
            <subtitles>
                <eb:FooterSubtitle runat="server" Caption="(miejscowość, data)" ID="stData" Width="50"></eb:FooterSubtitle>
                <eb:FooterSubtitle runat="server" Caption="(podpis)" ID="stPodpis" Width="50"></eb:FooterSubtitle>
          </subtitles>
        </eb:ReportFooter>
    </form>
</body>
</html>
